<?php
define('BLOG',TRUE);

if ( @file_exists('core/data/config.ini') ) {

    die('Ошибка! Скрипт уже установлен!');

}

if ( !file_exists('core/data/tables.php') ) {

    die('Ошибка! Таблицы не найдены!');

}

# Локаль
@setlocale (LC_ALL, 'ru_RU.UTF8');
# Временная зона
date_default_timezone_set('Europe/Moscow');
# Отключаем ошибки
error_reporting(0);

require_once( 'core/classes/ini.class.php' );

$config = ini::read( 'core/data/config_tmp.ini' );

$config['db_host']    = !empty($_POST['db_host'])    ? $_POST['db_host']  : 'localhost';
$config['db_user']    = !empty($_POST['db_user'])    ? $_POST['db_user']    : '';
$config['db_pass']    = !empty($_POST['db_pass'])    ? $_POST['db_pass']    : '';
$config['db_name']    = !empty($_POST['db_name'])    ? $_POST['db_name']    : '';
$config['db_prefix']  = !empty($_POST['db_prefix'])  ? $_POST['db_prefix']  : 'bl_';
$config['db_collate'] = !empty($_POST['db_collate']) ? $_POST['db_collate'] : 'utf8';

$login      = !empty($_POST['login'])      ? $_POST['login']  : '';
$email      = !empty($_POST['email'])      ? $_POST['email']  : '';
$passwd     = !empty($_POST['passwd'])     ? $_POST['passwd'] : '';
$link       = false;
$p_error_msg = $login_error_msg = $email_error_msg = '';
$l_alert = $e_alert = $p_alert = $db_alert = '';

$header = <<<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Установка Блога</title>

<link href="/favicon.ico" rel="shortcut icon" />
<script type="text/javascript">
<!--
function ManualChangeStatus(checked) {
    if (checked == false) {
		document.getElementById('db_server').disabled = false;
		document.getElementById('db_name').disabled = false;
		document.getElementById('db_user').disabled = false;
		document.getElementById('db_pass').disabled = false;
		document.getElementById('db_prefix').disabled = false;
		document.getElementById('next').value = 'Продолжить';
    } else {
		document.getElementById('db_server').disabled = true;
		document.getElementById('db_name').disabled = true;
		document.getElementById('db_user').disabled = true;
		document.getElementById('db_pass').disabled = true;
		document.getElementById('db_prefix').disabled = true;
		document.getElementById('next').value = 'Получить дамп БД';
    }
}
// -->
</script>
<style type="text/css">
html {background:transparent;}
body {font-family:Arial, Helvetica, "DejaVu Sans", sans-serif;font-size:12px;max-width:1280px;min-width:800px;margin: 0 auto;background:transparent;}

h1 {padding-left:10px;font-weight:normal;font-size:2.667em;margin-bottom:15px;} 
h2 {font-size:2em;font-weight:normal;margin:30px 0 15px;}
h3 {font-size:1.5em;font-weight:normal;margin:15px 0 10px;}

a {color:#000;}
a:hover {text-decoration:none;}
a.inpage {text-decoration:none;border-bottom:1px dashed;}
a.inpage:hover {border-bottom:0px none;}
a.inpage:focus {outline:1px dotted #777;}

p {font-size:1.167em;line-height:1.4em;margin-bottom:5px;}
h4 {font-size:1.167em;line-height:1.4em;margin-bottom:10px;font-weight:normal;}

label {font-size:14px;color:#000;}
label.block {display:block;margin-bottom:5px;}
small.hint {color:#acacac;display:block;margin-top:4px;font-size:12px;}
p small.hint, label small.hint {margin:0;display:inline;}

#wrapper {position: relative;margin:10px 25px 10px 25px;//height:0;}
#header {position:relative;z-index:50;}
#content {margin:20px 10px 0 10px;clear:both;}
#footer {clear:both;height:11px;}

table.form {margin-bottom:20px;}
.form td, .form th {padding:3px 5px 3px 0;vertical-align:top;}
.form th.section {background:#F1F2F2;text-align:left;font-weight:normal;padding:10px 5px;font-size:1.167em;}
.form .required {display:inline-block;vertical-align:baseline;width:.5em;position:relative;left:-.5em;margin-right:-.5em;color:#f3152b;}

div.notable {background:#F1F2F2;width:100%;padding:10px 10px 20px 10px;position:relative;left:-10px;z-index:0;}
div.notable .wrap {width:80%;margin:0 auto;}
div.notable .wrap-center {text-align:center;}
div.notable .wrap-center .wrap {display:inline-block;width:auto;text-align:left;}

.notable p {margin-bottom:10px;}
.notable .description {color:#666;}
.notable .section {padding-bottom:15px;position:relative;}
.notable .short-section {width:80%;}
.notable h1 {font-size:2em;padding:0;margin-top:20px;}
.notable h2 {color:#666;margin:0 auto 10px;font-size:1.333em;}
.notable h1 label {font-size:1em;color:#000;}
.notable .section textarea {width:99%;}
.notable .outer-hint {width:200px;position:absolute;right:-220px;top:0;}
</style>

</head>
<body>
<div id="wrapper">
  <div id="header">
    <h1>Установка Блога</h1>
  </div>
  <div id="main">
    <div id="content">

      <!-- content -->

HTML;

if (!empty($_POST['install'])) {

    $error = false;

    if ( $login == '' || strlen($login) < 3 || strlen($login) > 30 ) {

        $l_alert = "border:solid 1px #FF0000;color:Red;";
        $error = true;
        $login_error_msg = 'Ошибка! Слишком короткий или длинный логин (min 3, max 32)!';
    }
    else if ( $email == '' ) {

        $e_alert = "border:solid 1px #FF0000;color:Red;";
        $error = true;
        $email_error_msg = 'Ошибка! Вы не ввели E-Mail адрес!';
    }
    else if ( $passwd == '' || strlen($passwd) < 3 || strlen($passwd) > 30 ) {

        $p_alert = "border:solid 1px #FF0000;color:Red;";
        $error = true;
        $p_error_msg = 'Ошибка! Слишком короткий или длинный пароль (min 3, max 32)!';
    }
    else if ( empty($_POST['manual']) && ($config['db_user'] == '' || $config['db_pass'] == '' || $config['db_name'] == '') ) {

        $db_alert = "border:solid 1px #FF0000;color:Red;";
        $error = true;
    }

    if ( !$error ) {

        include('core/dbsimple/Generic.php');

        include('core/data/tables.php');

        if (!empty($_POST['manual'])) {

            $dump = '';
            $dump_data = date( 'd_m_Y' );
            $dump .= create_table( $login, $email, $passwd, 1 );
            $dump = str_replace( '?_', $config['db_prefix'], $dump );
            header( "Cache-Control: \"private\"\n" );
            header( "Content-type: text/plain" );
            header( "Content-Disposition: attachment; filename=\"blog_dump_".$dump_data.".sql\"" );
            echo $dump;
            exit( );
        }
        else {

            if ( $link = mysql_connect($config['db_host'], $config['db_user'], $config['db_pass']) ) {

                if ( mysql_select_db($config['db_name'],$link) ) {

                    $db = @DbSimple_Generic::connect( 'mysql://'.$config['db_user'].':'.$config['db_pass'].'@'.$config['db_host'].'/'.$config['db_name'] );

                    $db->setIdentPrefix($config['db_prefix']);
                    $db->query( "SET NAMES " . $config['db_collate'] );
                    $db->query( "SET character_set_client = " . $config['db_collate'] );
                    $db->query( "SET character_set_connection = " . $config['db_collate'] );
                    $db->query( "SET character_set_database = " . $config['db_collate'] );
                    $db->query( "SET character_set_results = " . $config['db_collate'] );
                    $db->query( "SET character_set_server = " . $config['db_collate'] );

                    create_table( $login, $email, $passwd );

                    echo $header;

                    $config['key']      = mt_rand(111111111,999999999);
                    $config['login']    = $login;
                    $config['site_url'] = 'http://' . $_SERVER['HTTP_HOST'];

                    ini::save( 'core/data/config.ini', $config );

                    if (file_exists('core/cache/categories.php')) unlink('core/cache/categories.php');
                    if (file_exists('core/cache/counts_posts.php')) unlink('core/cache/counts_posts.php');
                    if (file_exists('core/cache/static_index.php')) unlink('core/cache/static_index.php');
                    if (file_exists('core/cache/static_pages.php')) unlink('core/cache/static_pages.php');
                    if (file_exists('core/cache/stat_blog.php')) unlink('core/cache/stat_blog.php');

                    echo <<<HTML

	<big class="num center">Установка завершена</big>
	<p class="center">
		<span style="color:red;">Не забудте удалить файл install.php</span><br />
		<a href="/">Начать работу</a>
	</p>
      <!-- /content -->
    </div>
  </div>
  <div id="footer"></div>
</div>
</body>
</html>
HTML;
die();
                }
                else {

                    $db_alert = "border:solid 1px #FF0000;color:Red;";
                    $error    = TRUE;
                }
            }
            else {

                $db_alert = "border:solid 1px #FF0000;color:Red;";
                $error    = TRUE;
            }
        }
    }
}

echo $header;

?>
<form action="?" method="post">
<div class="notable">
<div class="wrap">
	<input name="install" type="hidden" value="1">
	<h3>Конфигурация</h3>
	<table class="form">
	<tr>
		<td><p>Адрес сайта:</p></td>
		<td><input name="http_host" type="text" value="http://<?=$_SERVER['HTTP_HOST']?>"></td>
	</tr>
	<tr>
		<td><label for="email">Логин администратора:</label></td>
		<td><input name="login" id="login" value="<?=$login?>" style="<?=$l_alert?>" type="text"><br /><?=$login_error_msg?></td>
	</tr>
	<tr>
		<td><label for="email">Email администратора:</label></td>
		<td><input name="email" id="email" value="<?=$email?>" style="<?=$e_alert?>" type="text"><br /><?=$email_error_msg?></td>
	</tr>
	<tr>
		<td><label for="passwd">Пароль:</label></td>
		<td><input id="passwd" name="passwd" value="<?=$passwd?>" style="<?=$p_alert?>" type="text"><br /><?=$p_error_msg?></td>
	</tr>
	<tr>
		<td><label for="manual">Ручная установка. Получить дамп БД.</label></td>
		<td><input onclick="ManualChangeStatus(this.checked)" name="manual" value="1" type="checkbox" id="manual" /><br /></td>
	</tr>
	</table>

	<p class="alert">
		<strong>Внимание!</strong>
		<br />
		Существующие таблицы будут удалены!
	</p>

	<table class="form">
	<tr>
		<td><label for="db_server">Адрес сервера БД:</label></td>
		<td><input id="db_server" name="db_host" value="<?=$config['db_host']?>" style="<?=$db_alert?>" type="text" /></td>
	</tr>
	<tr>
		<td><label for="db_user">Пользователь БД:</label></td>
		<td><input id="db_user" name="db_user" value="<?=$config['db_user']?>" type="text" style="<?=$db_alert?>" /></td>
	</tr>
	<tr>
		<td><label for="db_pass">Пароль БД:</label></td>
		<td><input id="db_pass" name="db_pass" style="<?=$db_alert?>" type="password" /></td>
	</tr>
	<tr>
		<td><label for="db_name">Имя БД:</label></td>
		<td><input id="db_name" name="db_name" value="<?=$config['db_name']?>" type="text" style="<?=$db_alert?>" /></td>
	</tr>
	<tr>
		<td><label for="db_prefix">Префикс таблиц:</label></td>
		<td><input id="db_prefix" name="db_prefix" value="<?=$config['db_prefix']?>" type="text" style="<?=$db_alert?>" />
		<small class="hint">Только латинские буквы!<br />Максимум 10 символов.</small></td>
	</tr>
	<tr>
		<td><label for="db_pass">Кодировка:</label></td>
		<td>
		<select name="db_collate">
			<option value="utf8">UTF-8</option>
		</select>
		</td>
	</tr>
	</table>
	<p class="center">
		<input id="next" type="submit" value="Продолжить &gt;&gt;&gt;" />
	</p>

</div>
</div>
</form>
      
      
      <!-- /content -->
    </div>
  </div>
  <div id="footer"></div>
</div>
</body>
</html>